require( "scripts/style.lua" );



InfoFont = {
  standardFont,
  16,
  BorderColor
};

kRowSpace = 60;
kRightColumn = 360;
kTopPad = 20;
kTopBorder = 10;
kFieldSpace = 100;
kLeftPad = 2;
kFieldScale = 0.48;
kTextOffset = 35;

CustomerButtonGraphics = {
	"backgrounds/textfield",
	"backgrounds/textfield",
	"backgrounds/textfield"
};

function MakeRow( row, column, num )
	columnSpace = kRightColumn * column;
	red = 0.75;
	green = 0.75;
	blue = 0.75;
	if (row == 0 or row == 2 or row == 4 or row == 6 or row == 8) then
		red = 0.65;
		green = 0.65;
		blue = 0.65;
	end
	return Group(
		{
			FillWindow
			{
				x = 0, y = kTopBorder  + (row * kRowSpace) - 5,
				w = 800, h = kRowSpace,
				r = red,
				g = green,
				b = blue,
			};
			
			Text
			{
				font = InfoFont,
				name = "goal"..num,
				x=140,y=kTopBorder  + (row * kRowSpace),w=100,h=20,
				flags = kHAlignRight + kVAlignTop,
				label = "le_goal"
			};
			Bitmap
			{
				image="backgrounds/textfield.png",
				x=250,
				y= kTopBorder  + (row * kRowSpace),
				scale = kFieldScale,
				
				TextEdit
				{
					font = SmallButtonFont,
					name = "goalval"..num,
					x=5,y=0,w=kMax-5,h=kMax,
					length=40
				};
			};
			
			Text
			{
				font = InfoFont,
				name = "time"..num,
				x=345,y=kTopBorder  + (row * kRowSpace),w=100,h=20,
				flags = kHAlignRight + kVAlignTop,
				label = "le_time"
			};
			Bitmap
			{
				image="backgrounds/textfield.png",
				x=450,
				y= kTopBorder + (row * kRowSpace),
				scale = kFieldScale,
				
				TextEdit
				{
					font = SmallButtonFont,
					name = "timeval"..num,
					x=5,y=0,w=kMax-5,h=kMax,
					length=40
				};
			};
			Text
			{
				font = InfoFont,
				name = "time"..num,
				x=columnSpace + kLeftPad,y=kTopBorder  + (row * kRowSpace) + kTextOffset,w=kFieldSpace,h=20,
				flags = kHAlignCenter + kVAlignTop,
				label = "le_type"
			};
			
			Button
			{
				font = SmallButtonFont,
				type = kPush,
				x=columnSpace + kLeftPad,
				y=kTopBorder +kTopPad + (row * kRowSpace),
				scale = kFieldScale,
				graphics = CustomerButtonGraphics,
				Text
				{
					font = SmallButtonFont,
					name = "typeval_a"..num,
					x=5,y=0,w=kMax-5,h=kMax,
					length=40
				};
				command =
					function()
						returnval = DoModal("scripts/leveleditor/customers.lua");
						if (not(returnval == nil)) then
							SetWindowText("typeval_a"..num, returnval);
						end
					end
			};
			
			
			Text
			{
				font = InfoFont,
				name = "time"..num,
				x=columnSpace + kLeftPad + (kFieldSpace * 1),y=kTopBorder  + (row * kRowSpace) + kTextOffset,w=kFieldSpace,h=20,
				flags = kHAlignCenter + kVAlignTop,
				label = "le_frequency"
			};
			Bitmap
			{
				image="backgrounds/textfield.png",
				x=columnSpace + kLeftPad + (kFieldSpace * 1),
				y=kTopBorder +kTopPad + (row * kRowSpace),
				scale = kFieldScale,
				
				TextEdit
				{
					font = SmallButtonFont,
					name = "freqval_a"..num,
					x=5,y=0,w=kMax-5,h=kMax,
					length=40
				};
			};
			
			Text
			{
				font = InfoFont,
				name = "time"..num,
				x=columnSpace + kLeftPad + (kFieldSpace * 2),y=kTopBorder  + (row * kRowSpace) + kTextOffset,w=kFieldSpace,h=20,
				flags = kHAlignCenter + kVAlignTop,
				label = "le_type"
			};
			
			Button
			{
				font = SmallButtonFont,
				type = kPush,
				x=columnSpace + kLeftPad + (kFieldSpace * 2),
				y=kTopBorder +kTopPad + (row * kRowSpace),
				scale = kFieldScale,
				graphics = CustomerButtonGraphics,
				Text
				{
					font = SmallButtonFont,
					name = "typeval_b"..num,
					x=5,y=0,w=kMax-5,h=kMax,
					length=40
				};
				command =
					function()
						returnval = DoModal("scripts/leveleditor/customers.lua");
						if (not(returnval == nil)) then
							SetWindowText("typeval_b"..num, returnval);
						end
					end
			};
			
			
			Text
			{
				font = InfoFont,
				name = "time"..num,
				x=columnSpace + kLeftPad + (kFieldSpace * 3),y=kTopBorder  + (row * kRowSpace) + kTextOffset,w=kFieldSpace,h=20,
				flags = kHAlignCenter + kVAlignTop,
				label = "le_frequency"
			};
			
			Bitmap
			{
				image="backgrounds/textfield.png",
				x=columnSpace + kLeftPad + (kFieldSpace * 3),
				y=kTopBorder +kTopPad + (row * kRowSpace),
				scale = kFieldScale,
				
				TextEdit
				{
					font = SmallButtonFont,
					name = "freqval_b"..num,
					x=5,y=0,w=kMax-5,h=kMax,
					length=40
				};
			};
			
			Text
			{
				font = InfoFont,
				name = "time"..num,
				x=columnSpace + kLeftPad + (kFieldSpace * 4),y=kTopBorder  + (row * kRowSpace) + kTextOffset,w=kFieldSpace,h=20,
				flags = kHAlignCenter + kVAlignTop,
				label = "le_type"
			};
			Button
			{
				font = SmallButtonFont,
				type = kPush,
				x=columnSpace + kLeftPad + (kFieldSpace * 4),
				y=kTopBorder +kTopPad + (row * kRowSpace),
				scale = kFieldScale,
				graphics = CustomerButtonGraphics,
				Text
				{
					font = SmallButtonFont,
					name = "typeval_c"..num,
					x=5,y=0,w=kMax-5,h=kMax,
					length=40
				};
				command =
					function()
						returnval = DoModal("scripts/leveleditor/customers.lua");
						if (not(returnval == nil)) then
							SetWindowText("typeval_c"..num, returnval);
						end
					end
			};
			
			Text
			{
				font = InfoFont,
				name = "time"..num,
				x=columnSpace + kLeftPad + (kFieldSpace * 5),y=kTopBorder  + (row * kRowSpace) + kTextOffset,w=kFieldSpace,h=20,
				flags = kHAlignCenter + kVAlignTop,
				label = "le_frequency"
			};
			Bitmap
			{
				image="backgrounds/textfield.png",
				x=columnSpace + kLeftPad + (kFieldSpace * 5),
				y=kTopBorder +kTopPad + (row * kRowSpace),
				scale = kFieldScale,
				
				TextEdit
				{
					font = SmallButtonFont,
					name = "freqval_c"..num,
					x=5,y=0,w=kMax-5,h=kMax,
					length=40
				};
			};
			
			Text
			{
				font = InfoFont,
				name = "time"..num,
				x=columnSpace + kLeftPad + (kFieldSpace * 6),y=kTopBorder  + (row * kRowSpace) + kTextOffset,w=kFieldSpace,h=20,
				flags = kHAlignCenter + kVAlignTop,
				label = "le_type"
			};
			
			Button
			{
				font = SmallButtonFont,
				type = kPush,
				x=columnSpace + kLeftPad + (kFieldSpace * 6),
				y=kTopBorder +kTopPad + (row * kRowSpace),
				scale = kFieldScale,
				graphics = CustomerButtonGraphics,
				Text
				{
					font = SmallButtonFont,
					name = "typeval_d"..num,
					x=5,y=0,w=kMax-5,h=kMax,
					length=40
				};
				command =
					function()
						returnval = DoModal("scripts/leveleditor/customers.lua");
						if (not(returnval == nil)) then
							SetWindowText("typeval_d"..num, returnval);
						end
					end
			};
			
			Text
			{
				font = InfoFont,
				name = "time"..num,
				x=columnSpace + kLeftPad + (kFieldSpace * 7),y=kTopBorder  + (row * kRowSpace) + kTextOffset,w=kFieldSpace,h=20,
				flags = kHAlignCenter + kVAlignTop,
				label = "le_frequency"
			};
			
			Bitmap
			{
				image="backgrounds/textfield.png",
				x=columnSpace + kLeftPad + (kFieldSpace * 7),
				y=kTopBorder +kTopPad + (row * kRowSpace),
				scale = kFieldScale,
				
				TextEdit
				{
					font = SmallButtonFont,
					name = "freqval_d"..num,
					x=5,y=0,w=kMax-5,h=kMax,
					length=40
				};
			};
		}
	)
end

function MakeRows( )
	local windows = {};
	for i=0,8 do
		table.insert(windows, MakeRow(i,0,i));
	end;
	return Group(windows);
end

MakeDialog
{
	FillWindow
	{
		x=0,
		y=0,
		w=800,
		h=600,
		r = 0.0,
		g = 0.0,
		b = 0.0,
		
		
		
		MakeRows();
		
		Button
		{
			x=kCenter,
			y=550,
			font = StandardButtonFont,
			graphics = SolidButtonGraphics,
			name="back",
			label="back",
			type = kPush,
			command=
				function()
					RecordCustomers();
					PopModal("scripts/leveleditor/endlessmode.lua");
				end
		},
	}
}

SetupCustomers();


